 ; Ŀ
 ;   Bean - vertically renumber/restring terminal blocks or text.          
 ;   Beans - vertically renumber, ignore Shields.                          
 ;   Bna - vertically renumber/restring terminal blocks and text.          
 ;   Spa - change to "Spare n" in reverse vertical order.                  
 ;   Aps - change to "n Spare" in reverse vertical order.                  
 ;   Copyright 1999, 2001, 2004 - 2010 by Rocket Software Ltd.             
 ;   There are no squid dishes in which the tentacles are served whole.    
 ; 

 ; Ŀ
 ;   Subroutine Alpha - increment a character string.                      
 ;   Takes one argument, a string.  Returns the incremented version.       
 ; 
 (DEFUN ALPHA (cname / pos char base cname cnamp chasci)
  (setq pos (strlen cname))
  (while (and (>= pos 1)
              (setq char (substr cname pos 1))
              (<= 90 (ascii char)))
         (setq pos (1- pos)))
 ; Ŀ
 ;   If no non-z characters were found, set all to 0 and add an 0 to the   
 ;   left end of the string.                                               
 ; 
  (cond ((= pos 0)
         (setq base "")
         (repeat (1+ (strlen cname))
                 (setq base (strcat base "0")))
         (setq cname base))
 ; Ŀ
 ;   If a non-Z was found, everything to the right of it becomes a 0, and  
 ;   it is incremented.                                                    
 ; 
        (T (setq cnamp cname)
           (setq cname (strcat (substr cnamp 1 (1- pos))))
           (setq char (chr (1+ (ascii (substr cnamp pos 1)))))
           (setq chasci (ascii char))
           (if (and (>= chasci 58) (<= chasci 64))
               (setq char "A"))
           (setq base "")
           (repeat (strlen (substr cnamp (1+ pos)))
                   (setq base (strcat base "0")))
           (setq cname (strcat cname char base))))
 cname)
 ; Ŀ
 ;   Alpha end.                                                            
 ; 

 ; Ŀ
 ;   Sela - decide whether a selection set is mostly text or blocks -      
 ;   divide it up into a list of text and each type of block, return       
 ;   the longest list.                                                     
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns an ss or nil.  Probably.                                      
 ; 
 (DEFUN SELA (/ ss num enam entt typ txlist blnam sub malist clen len)
  (setq ss (ssget '((-4 . "<or")
                     (-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>")
                     (0 . "text") (-4 . "or>"))))
  (setq num 0)
  (while (setq enam (ssname ss num))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (cond ((= typ "TEXT")
                (setq txlist (cons enam txlist)))
               ((= typ "INSERT")
                (setq blnam (cdr (assoc 2 entt)))
                (if (setq sub (assoc blnam malist))
                    (setq malist (subst (append sub (list enam)) sub malist))
                    (setq malist (append malist (list (list blnam enam))))))))
 ; Ŀ
 ;   Find the longest list.                                                
 ; 
  (setq clen (length txlist))
  (setq num 0)
  (while (and malist (setq sub (nth num malist)))
         (setq num (1+ num))
 ; Ŀ
 ;   Note that the block sublists contain a name and the text list         
 ;   doesn't, so if they are the same length the text list is longer.      
 ; 
         (if (not (>= clen (setq len (length sub))))
             (progn
                  (setq txlist sub)
                  (setq clen len))))
 ; Ŀ
 ;   Knock off the leading element from the list if it's a string.         
 ; 
  (setq txlist (if (= (type (car txlist)) 'STR) (cdr txlist) txlist))
 ; Ŀ
 ;   Vtol takes an ss as its argument, so want to return an ss rather      
 ;   than the list which we currently have.                                
 ; 
  (setq num 0)
  (while (setq enam (ssname ss num))
         (if (member enam txlist)
             (setq num (1+ num))
             (ssdel enam ss)))
 ; Ŀ
 ;   Return the ss.                                                        
 ; 
 ss) 
 ; Ŀ
 ;   Sela end.                                                             
 ; 

 ; Ŀ
 ;   Selb - get an ss of text and blocks.                                  
 ;   Takes no arguments, calls nothing.                                    
 ;   Returns an ss or nil.  Probably.                                      
 ; 
 (DEFUN SELB (/ ss)
  (setq ss (ssget '((-4 . "<or")
                     (-4 . "<and") (0 . "insert") (66 . 1) (-4 . "and>")
                     (0 . "text") (-4 . "or>"))))
 ss) 
 ; Ŀ
 ;   Selb end.                                                             
 ; 

 ; Ŀ
 ;   Spit - returns the insertion point of the text entity whose data was  
 ;   passed as its sole argument.  Note that this is not necessarily the   
 ;   same as the 10 association code.                                      
 ; 
 (DEFUN SPIT (entt / xjust yjust)
  (setq xjust (cdr (assoc 72 entt)))
  (if (= (cdr (assoc 0 entt)) "ATTDEF")
      (setq yjust (cdr (assoc 74 entt)))
      (setq yjust (cdr (assoc 73 entt))))
  (if (or (/= xjust 0) (/= yjust 0))
      (cdr (assoc 11 entt))
      (cdr (assoc 10 entt))))
 ; Ŀ
 ;   Spit end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Vtol: returns a list of enames ordered entity position.    
 ;   Arguments: Ss, a selection set of entities to order.                  
 ;              Dir, a direction - if this is either "X" or "Y" then the   
 ;                   entities are assumed to be arrayed in that direction, 
 ;                   if anything else then the routine uses the direction  
 ;                   in which they are most spread out.                    
 ;              Insa, if T and the entity is text or an attribute then     
 ;                    sort based on the insertion point rather than the    
 ;                    ten point.                                           
 ;                                                                         
 ;   This is the latest version: 2006.10.05, which sorts text by           
 ;   insertion point rather than ten point and in which setting the        
 ;   direction to nil doesn't cause a crash.                               
 ;   Also it works with attdefs as well as text.                           
 ;   It should replace all other uses of Vtol and Stol.                    
 ;                                                                         
 ;   Revamped 2009.07.28 to use Apply rather than Eval Cons 'Max List etc. 
 ;   This is less elegant but removes the 256 entity limitation.           
 ;   Also added the ability to sort by either ten point or insertion.      
 ;                                                                         
 ; 
 (DEFUN VTOL (ss dir insa / xposnam yposnam numm ent entt ten xpos ypos xx yy
                            pn maxx minx maxy miny xdif ydif poslst posnam
                                                       direct pos lastt order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (if (and insa (member (cdr (assoc 0 entt)) '("TEXT" "ATTDEF")))
             (setq ten (spit entt))
             (setq ten (cdr (assoc 10 entt))))
         (setq xpos (car ten))
         (setq ypos (cadr ten))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now evaluate the four lists.  The result will be the max and min      
 ;   values for the X and Y lists.                                         
 ; 
  (setq maxx (apply 'max xx))
  (setq minx (apply 'min xx))
  (setq maxy (apply 'max yy))
  (setq miny (apply 'min yy))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set direction variables to match whichever direction was given in     
 ;   the argument, if it was nil then deduce a direction.                  
 ; 
  (cond ((and (= (type dir) 'STR)
              (= (strcase dir) "X"))
          (setq poslst xx)                ; positions from X coord list
          (setq posnam xposnam)           ; position & ename list with X coord
          (setq direct 'min))             ; edit from smallest to largest X
        ((and (= (type dir) 'STR)
              (= (strcase dir) "Y"))
         (setq poslst yy)
         (setq posnam yposnam)
         (setq direct 'max))
        (T
 ; Ŀ
 ;   The default case: figure it out yourself.                             
 ;   Set vert to T if vertical, nil if horizontal.                         
 ;   If not sure, assume vertical.                                         
 ;   Could set strip to Quit and thus do so...                             
 ; 
         (cond ((> xdif ydif)             ; if (Xmax - Xmin) > (Ymax - Ymin)
                (setq poslst xx)          ; positions from X coord list
                (setq posnam xposnam)     ; position & ename list with X coord
                (setq direct 'min))       ; edit from smallest to largest X
               ((< xdif ydif)
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max))
               (T                         ; if not sure then call it vertical
                (setq poslst yy)
                (setq posnam yposnam)
                (setq direct 'max)))))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (apply direct poslst))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq lastt (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq lastt (cdr lastt))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq lastt (append (list (nth pos poslst)) lastt))
                (setq pos (1- pos)))
         (setq poslst lastt)      ; poslst becomes lastt
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Vtol end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Bean.                                                      
 ;   Arguments: Fila, filter for block/text, t =  yes, nil = no.           
 ;              Pref, prefix string or nil.                                
 ;              Suff, suffix string or nil.                                
 ;              Reve, renumber the entities in reverse order.              
 ;              Igno, a list of strings - if a text entity or attribute    
 ;                    contains one of these it will be ignored.            
 ;                    Entries must be lower case.                          
 ; 
 (DEFUN BEAN (fila pref suff reve igno / ss orlst nt isint num enam esav entt
                                 incr asoc1 stana len blen etype blnam gonext)
  (setvar "cmdecho" 0)
  (command "undo" "be")
  (grtext -1 "Rocket Software")
  (write-line "Terminal Blocks/Text: ")
  (if fila
      (setq ss (sela))
      (setq ss (selb)))
  (setq orlst (vtol ss nil t))  ; vtol returns an ename list ordered by pos.
 ; Ŀ
 ;   If Reve is set then reverse the entity list.                          
 ; 
  (if reve (setq orlst (reverse orlst)))
 ; Ŀ
 ;   Get the text or first attribute string.                               
 ; 
  (setq enam (car orlst))
  (setq entt (entget enam))
  (setq blnam (cdr (assoc 2 entt)))
  (if (and blnam (member (strcase blnam t)
                         '("terminal block" "fieldterminal")))
      (setq gonext t))  ; skip_first_attribute flag
  (setq typ (cdr (assoc 0 entt)))
  (cond ((= typ "INSERT")
         (if gonext
             (setq entt (entget (entnext (entnext enam))))
             (setq entt (entget (entnext enam))))
         (setq stana (cdr (assoc 1 entt))))
        ((= typ "TEXT")
         (setq stana (cdr (assoc 1 entt)))))
 ; Ŀ
 ;   Knock off the first and/or last part of the base string if they match 
 ;   the prefix or suffix.                                                 
 ; 
  (if pref
      (progn
           (setq len (strlen pref))
           (if (equal (substr stana 1 len) pref)
               (setq stana (substr stana (1+ len))))))
  (if suff
      (progn
           (setq len (strlen suff))
           (setq blen (strlen stana))
           (if (equal (substr stana (- blen len -1)) suff)
               (setq stana (substr stana 1 (- blen len))))))
 ; Ŀ
 ;   Make a default start string if the original was empty.                
 ; 
  (if (= stana "")
      (setq stana "1"))
 ; Ŀ
 ;   Get the start string.                                                 
 ; 
  (setq nt (getstring (strcat "Start Number/String <" stana ">: ")))
  (if (= nt "") (setq nt stana))
 ; Ŀ
 ;   If the string is a number then set Isint, the number flag.            
 ; 
  (if (= (type (read nt)) 'INT)
      (progn
           (setq isint t)
           (setq nt (read nt))))
 ; Ŀ
 ;   Renumber them.                                                        
 ; 
  (setq num 0)
  (while (setq esav (nth num orlst))
         (setq entt (entget esav))
         (setq etype (cdr (assoc 0 entt)))
 ; Ŀ
 ;   Get the string.                                                       
 ; 
         (cond ((= etype "INSERT")
                (setq str (cdr (assoc 1 (entget (entnext esav))))))
               (t
                (setq str (cdr (assoc 1 entt)))))
 ; Ŀ
 ;   Restring the entities.                                                
 ;   Unless the string was in the ignore list.                             
 ; 
         (setq num (1+ num))
         (setq incr t)
         (cond ((member (strcase str t) igno)
                (setq incr nil))
 ; Ŀ
 ;   The current entity is text and the string is an integer.              
 ; 
               ((and isint (= etype "TEXT"))
                (setq nustr (itoa nt))
                (if pref (setq nustr (strcat pref nustr)))
                (if suff (setq nustr (strcat nustr suff)))
                (entmod (subst (cons 1 nustr) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The entity was text.                                                  
 ; 
               ((= etype "TEXT")
                (if pref
                   (setq nustr (strcat pref nt))
                   (setq nustr nt))
                (if suff (setq nustr (strcat nustr suff)))
                (entmod (subst (cons 1 nustr) (assoc 1 entt) entt)))
 ; Ŀ
 ;   The entity was a number but not text.                                 
 ; 
               (isint
                (if gonext
                    (setq entt (entget (entnext (entnext esav))))
                    (setq entt (entget (entnext esav))))
                (setq asoc1 (assoc 1 entt))
                (setq nustr (itoa nt))
                (if pref (setq nustr (strcat pref nustr)))
                (if suff (setq nustr (strcat nustr suff)))
                (entmod (subst (cons 1 nustr) asoc1 entt))
                (entupd esav))
 ; Ŀ
 ;   No idea - the default.                                                
 ; 
               (t
                (setq entt (entget (entnext esav)))
                (if gonext
                    (setq entt (entget (entnext (entnext esav))))
                    (setq entt (entget (entnext esav))))
                (setq asoc1 (assoc 1 entt))
                (if pref
                   (setq nustr (strcat pref nt))
                   (setq nustr nt))
                (if suff (setq nustr (strcat nustr suff)))
                (entmod (subst (cons 1 nustr) asoc1 entt))
                (entupd esav)))
         (if incr
             (if isint
                 (setq nt (1+ nt))
                 (setq nt (alpha nt)))))
  (command "undo" "end")
 (princ))
 ; Ŀ
 ;   Subroutine Bean end.                                                  
 ; 

 ; Ŀ
 ;   Spa - don't filter out text and different types of blocks, prefix     
 ;   "Spare " to strings.                                                  
 ; 
 (DEFUN C:SPA ()
  (bean nil "SPARE " nil T nil)
 (princ))

 ; Ŀ
 ;   Aps - don't filter out text and different types of blocks, append     
 ;   " Spare" to strings.                                                  
 ; 
 (DEFUN C:APS ()
  (bean nil nil " SPARE" T nil)
 (princ))

 ; Ŀ
 ;   Bna - don't filter out text and different types of blocks.            
 ; 
 (DEFUN C:BNA ()
  (bean nil nil nil nil nil)
 (princ))

 ; Ŀ
 ;   Bean.                                                                 
 ; 
 (DEFUN C:BEAN ()
  (bean t nil nil nil nil)
 (princ))

 ; Ŀ
 ;   Beans - like bean but ignore "Shield"s.                               
 ; 
 (DEFUN C:BEANS ()
  (bean t nil nil nil (list "shield" "shld" "shd"))
 (princ))

(princ)